﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.ComponentModel;

namespace The.NET_Downloader
{
    /// <summary>
    /// Interaction logic for OptionsWindow.xaml
    /// </summary>
    public partial class OptionsWindow : Window
    {
        public System.Configuration.SettingsPropertyCollection Props
        {
            get
            {
                return The.NET_Downloader.Properties.Settings.Default.Properties;
            }
        }
        Dictionary<string, string> Descriptions = new Dictionary<string, string>();
        public System.Configuration.SettingsProperty SelectedProperty
        {
            get
            {
                return listBox1.SelectedItem as System.Configuration.SettingsProperty ;
            }
        }
        public OptionsWindow()
        {
            InitializeComponent();

            Descriptions["MinSegmentSize"] = "";
            Descriptions["MinSegmentLeftToStartNewSegment"] = "";
            Descriptions["RetryDelay"] = "The time to wait between retries in milliseconds";
            Descriptions["MaxRetries"] = "The maximum amount of times to retry the download";
            Descriptions["DownloadFolder"] = "The location where the downloads are saved";
            Descriptions["ProxyAddress"] = "The Proxy Host";
            Descriptions["ProxyUserName"] = "The Proxy Username";
            Descriptions["ProxyPassword"] = "The Proxy Password";
            Descriptions["ProxyDomain"] = "";
            Descriptions["UseProxy"] = "Enable the proxy";
            Descriptions["ProxyByPassOnLocal"] = "";
            Descriptions["ProxyPort"] = "The port of the proxy";
            Descriptions["EnabledLimit"] = "";
            Descriptions["MaxRate"] = "";
            Descriptions["SimultaniousDownloads"] = "Amount of downloads to run at the same time";

        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            listBox1.Items.Refresh();

            foreach(System.Configuration.SettingsProperty property in Props)
                if(Descriptions.ContainsKey(property.Name))
                    if(!string.IsNullOrEmpty(Descriptions[property.Name]))
                        listBox1.Items.Add(property);
           
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
           
            var converter = TypeDescriptor.GetConverter((listBox1.SelectedItem as System.Configuration.SettingsProperty).PropertyType);
            var result = converter.ConvertFrom(textBoxValue.Text);
            Properties.Settings.Default[(listBox1.SelectedItem as System.Configuration.SettingsProperty).Name] = result;
            Properties.Settings.Default.Save();
        }

        private void listBox1_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            textBlockItemName.Text = SelectedProperty.Name;
            textBlockDescription.Text = Descriptions[SelectedProperty.Name];
            textBoxValue.Text = Properties.Settings.Default[SelectedProperty.Name].ToString();
        }

        private void textBoxValue_TextChanged(object sender, TextChangedEventArgs e)
        {

        }

        private void button2_Click(object sender, RoutedEventArgs e)
        {         
            Properties.Settings.Default[(listBox1.SelectedItem as System.Configuration.SettingsProperty).Name] = (listBox1.SelectedItem as System.Configuration.SettingsProperty).DefaultValue;
            textBoxValue.Text = (listBox1.SelectedItem as System.Configuration.SettingsProperty).DefaultValue.ToString();
            Properties.Settings.Default.Save();
        }
    }
}
